/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.util;

import cn.com.duiba.spring.boot.starter.dsp.enums.RedisBalance8KeyEnum;
import cn.com.duiba.spring.boot.starter.dsp.util.HashAlgorithm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class RedisBalanceKeyUtil {
    private static final String START = "{";
    private static final String END = "}";

    public static List<String> createRedisBalance8key(String prefix) {
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (RedisBalance8KeyEnum keyEnum : values) {
            String key = keyEnum.hashTag;
            String redisKey = StringUtils.join((Object[])new Serializable[]{prefix, "_", Integer.valueOf(keyEnum.order), START, key, END});
            list.add(redisKey);
        }
        return list;
    }

    public static String getRedisBalance8key(String prefix, String targetStr) {
        String HashStr = DigestUtils.md5Hex((String)targetStr);
        int targetHashValue = HashAlgorithm.dekHash(HashStr);
        RedisBalance8KeyEnum[] values = RedisBalance8KeyEnum.values();
        int mold = targetHashValue % values.length;
        for (RedisBalance8KeyEnum keyEnum : values) {
            if (!Objects.equals(keyEnum.order, mold)) continue;
            String key = keyEnum.hashTag;
            return StringUtils.join((Object[])new Serializable[]{prefix, "_", Integer.valueOf(keyEnum.order), START, key, END});
        }
        return null;
    }
}

