/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.util;

import cn.com.duiba.wolf.utils.NumberUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;

public class RedisBloomHandler<K, V> {
    private static final String RESERVE = "BF.RESERVE";
    private static final String ADD = "BF.ADD";
    private static final String MADD = "BF.MADD";
    private static final String EXISTS = "BF.EXISTS";
    private static final String MEXISTS = "BF.MEXISTS";
    @Resource(name="redisBloomStringRedisTemplate")
    private RedisTemplate redisTemplate;

    RedisSerializer keySerializer() {
        return this.redisTemplate.getKeySerializer();
    }

    RedisSerializer valueSerializer() {
        return this.redisTemplate.getValueSerializer();
    }

    RedisSerializer hashKeySerializer() {
        return this.redisTemplate.getHashKeySerializer();
    }

    RedisSerializer hashValueSerializer() {
        return this.redisTemplate.getHashValueSerializer();
    }

    RedisSerializer stringSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    public void createFilter(K key, double errorRate, long initCapacity) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawErrorRate = this.rawString(String.valueOf(errorRate));
        byte[] rawInitCapacity = this.rawString(String.valueOf(initCapacity));
        Object execute = this.redisTemplate.execute(connection -> {
            connection.execute(RESERVE, (byte[][])new byte[][]{rawKey, rawErrorRate, rawInitCapacity});
            return null;
        }, true);
    }

    public void createFilters(List<K> keys, double errorRate, long initCapacity) {
        byte[] rawErrorRate = this.rawString(String.valueOf(errorRate));
        byte[] rawInitCapacity = this.rawString(String.valueOf(initCapacity));
        Object execute = this.redisTemplate.execute(connection -> {
            keys.forEach(key -> {
                byte[] rawKey = this.rawKey(key);
                connection.execute(RESERVE, (byte[][])new byte[][]{rawKey, rawErrorRate, rawInitCapacity});
            });
            return null;
        }, true);
    }

    public void createFilterWithExpire(K key, double errorRate, long initCapacity, long seconds) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawErrorRate = this.rawString(String.valueOf(errorRate));
        byte[] rawInitCapacity = this.rawString(String.valueOf(initCapacity));
        Object execute = this.redisTemplate.execute(connection -> {
            connection.execute(RESERVE, (byte[][])new byte[][]{rawKey, rawErrorRate, rawInitCapacity});
            connection.expire(rawKey, seconds);
            return null;
        }, true);
    }

    public void createFiltersWithExpire(List<K> keys, double errorRate, long initCapacity, long seconds) {
        byte[] rawErrorRate = this.rawString(String.valueOf(errorRate));
        byte[] rawInitCapacity = this.rawString(String.valueOf(initCapacity));
        Object execute = this.redisTemplate.execute(connection -> {
            keys.forEach(key -> {
                byte[] rawKey = this.rawKey(key);
                connection.execute(RESERVE, (byte[][])new byte[][]{rawKey, rawErrorRate, rawInitCapacity});
                connection.expire(rawKey, seconds);
            });
            return null;
        }, true);
    }

    public Boolean add(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return (Boolean)this.redisTemplate.execute(connection -> {
            Long l = (Long)connection.execute(ADD, (byte[][])new byte[][]{rawKey, rawValue});
            return Objects.equals(l, 1L);
        }, true);
    }

    public Boolean[] addMulti(K key, V ... values) {
        byte[][] rawArgs = this.rawArgs(key, values);
        return (Boolean[])this.redisTemplate.execute(connection -> {
            List ls = (List)connection.execute(MADD, rawArgs);
            return ls.stream().map(l -> Objects.equals(l, 1L)).toArray(Boolean[]::new);
        }, true);
    }

    public boolean exists(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return (Boolean)this.redisTemplate.execute(connection -> {
            Long l = (Long)connection.execute(EXISTS, (byte[][])new byte[][]{rawKey, rawValue});
            return Objects.equals(l, 1L);
        }, true);
    }

    public Boolean[] existsMulti(K key, V ... values) {
        byte[][] rawArgs = this.rawArgs(key, values);
        return (Boolean[])this.redisTemplate.execute(connection -> {
            List ls = (List)connection.execute(MEXISTS, rawArgs);
            return ls.stream().map(l -> Objects.equals(l, 1L)).toArray(Boolean[]::new);
        }, true);
    }

    public Boolean delete(K key) {
        return this.redisTemplate.delete(key);
    }

    public Boolean expire(K key, long timeOut, TimeUnit timeUnit) {
        return this.redisTemplate.expire(key, timeOut, timeUnit);
    }

    public Boolean hasBloom(K key) {
        return this.redisTemplate.hasKey(key);
    }

    byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        return this.keySerializer() == null && key instanceof byte[] ? (byte[])key : this.keySerializer().serialize(key);
    }

    byte[] rawString(String key) {
        return this.stringSerializer().serialize((Object)key);
    }

    byte[] rawValue(Object value) {
        return this.valueSerializer() == null && value instanceof byte[] ? (byte[])value : this.valueSerializer().serialize(value);
    }

    private byte[][] rawArgs(Object key, Object ... values) {
        byte[][] rawArgs = new byte[1 + values.length][];
        int i = 0;
        rawArgs[i++] = this.rawKey(key);
        for (Object value : values) {
            rawArgs[i++] = this.rawValue(value);
        }
        return rawArgs;
    }

    public Integer saveBloom(String key, String value, Integer levelCount) {
        String luaText = "local a = ARGV[2]\nfor i = 1, #(ARGV)+1 do\n    if(redis.call('BF.ADD', KEYS[1], (ARGV[1] .. '_' .. i)) == 1) then\n        a = i;\n        break;\n    end\nend\nreturn a;";
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptSource((ScriptSource)new StaticScriptSource(luaText));
        redisScript.setResultType(Long.class);
        Object execute = this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(key), new Object[]{value, String.valueOf(levelCount)});
        if (NumberUtils.isNumeric((String)(execute + ""))) {
            return Integer.valueOf(execute + "");
        }
        return null;
    }

    public void createFiltersWithExpireAt(List<K> keys, double errorRate, long initCapacity, long expireAt) {
        byte[] rawErrorRate = this.rawString(String.valueOf(errorRate));
        byte[] rawInitCapacity = this.rawString(String.valueOf(initCapacity));
        Object execute = this.redisTemplate.execute(connection -> {
            keys.forEach(key -> {
                byte[] rawKey = this.rawKey(key);
                connection.execute(RESERVE, (byte[][])new byte[][]{rawKey, rawErrorRate, rawInitCapacity});
                connection.expireAt(rawKey, expireAt);
            });
            return null;
        }, true);
    }
}

