package cn.com.duibaboot.ext.autoconfigure.dubbo.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.deploy.DefaultApplicationDeployer;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;

@Configuration
public class DubboGracefulCloseAutoConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(DubboGracefulCloseAutoConfiguration.class);

    @Bean
    public DubboGracefulCloseLifeCycle dubboGracefulCloseLifeCycle() {
        return new DubboGracefulCloseLifeCycle();
    }

    /**
     * dubbo 优雅停机
     */
    public static class DubboGracefulCloseLifeCycle extends EarlyClose {

        @Autowired
        private ApplicationContext applicationContext;

        @Override
        public void stop() {

            if (!logger.isInfoEnabled()) {
                LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
                loggerContext.getLogger(DubboGracefulCloseAutoConfiguration.class).setLevel(Level.INFO);
            }

            try {
                // 通过反射直接执行DubboShutdownHook
                logger.info("clean up dubbo");
                Field field = DefaultApplicationDeployer.class.getDeclaredField("dubboShutdownHook");
                field.setAccessible(true);
                DefaultApplicationDeployer defaultApplicationDeployer = (DefaultApplicationDeployer) DefaultApplicationDeployer
                        .get(DubboBeanUtils.getModuleModel(applicationContext));
                DubboShutdownHook hook = (DubboShutdownHook) field.get(defaultApplicationDeployer);
                hook.run();
            } catch (ExceptionInInitializerError e) {
                // Ignore
            } catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }

        /**
         * Eureka/Consul的LifeCycle的phase是0，这里设置为-2
         * 1.让本类的stop会在取消注册之后被调用
         * 2.让本类晚于GracefulCloseLifeCycle执行
         *
         * @return
         */
        @Override
        public int getPhase() {
            return -2;
        }
    }
}
