package cn.com.duibaboot.ext.autoconfigure.dubbo.group;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

/**
 * 服务分组 dubbo服务端请求过滤器
 * 判断上游rpc请求上下文中，有没有服务分组的key，如果有那么将他放到内部调用上下文中，用于透传。
 * Created by gyf .
 * 2020/11/10 .
 */
@Activate(group = { CommonConstants.PROVIDER })
public class ServiceGroupDubboProviderFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String groupKey = RpcContext.getContext().getAttachment(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY);
        if (StringUtils.isNotBlank(groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }
        try {
            return invoker.invoke(invocation);
        } finally {
            ServiceGroupContext.removeGroupKey();
        }
    }
}
