/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class RocketMqProducerServiceGroupAspect {
    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("send") && signature.getParameterTypes().length >= 1 && signature.getParameterTypes()[0].equals(Message.class) && ServiceGroupContext.getCurrentGroupKey() != null) {
            Object[] args = joinPoint.getArgs();
            Message m = (Message)args[0];
            if (m != null) {
                m.putUserProperty("_duibaServiceGroupKey", ServiceGroupContext.getCurrentGroupKey());
            }
            return joinPoint.proceed(args);
        }
        return joinPoint.proceed();
    }
}

