/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.ConsumerProperties;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.DuibaRocketMqProperties;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.DuibaRocketmqListenerContainer;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

public class DuibaRocketmqListenerContainerFactory
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DuibaRocketmqListenerContainerFactory.class);
    private Environment environment;
    private BeanDefinitionRegistry registry;
    private final Map<String, ConsumerProperties> consumerPropertiesMap = Maps.newHashMap();
    private final Map<String, DuibaRocketmqListenerContainer> containers = Maps.newConcurrentMap();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        DuibaRocketMqProperties duibaRocketMqProperties = (DuibaRocketMqProperties)Binder.get((Environment)this.environment).bindOrCreate("duiba.rocketmq", DuibaRocketMqProperties.class);
        this.registerContainer("rocketMqConsumer", null, duibaRocketMqProperties.getConsumer());
        if (duibaRocketMqProperties.getExtraConsumer() == null) {
            return;
        }
        for (int i = 0; i < duibaRocketMqProperties.getExtraConsumer().length; ++i) {
            String beanName = "extraRocketMqConsumer" + i;
            this.registerContainer(beanName, null, duibaRocketMqProperties.getConsumer());
        }
    }

    public void registerContainer(String beanName, Integer index, ConsumerProperties consumerProperties) {
        if (consumerProperties == null) {
            return;
        }
        if (!consumerProperties.getEnable().booleanValue()) {
            return;
        }
        if (this.registry.containsBeanDefinition(beanName)) {
            return;
        }
        if (this.consumerPropertiesMap.containsKey(consumerProperties.getGroup())) {
            throw new RuntimeException("\u6d88\u8d39\u7ec4[" + consumerProperties.getGroup() + "]\u51b2\u7a81\uff0c\u914d\u7f6e\u4e24\u4e2a\u76f8\u540c\u7684\u6d88\u8d39\u7ec4\u6781\u6613\u4ea7\u751f\u8ba2\u9605\u4e00\u81f4\u6027\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u6d88\u8d39\u8005\u914d\u7f6e");
        }
        this.consumerPropertiesMap.put(consumerProperties.getGroup(), consumerProperties);
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DuibaRocketmqListenerContainer.class);
        beanDefinition.getPropertyValues().add("index", (Object)index);
        beanDefinition.getPropertyValues().add("consumerProperties", (Object)consumerProperties);
        beanDefinition.setScope("singleton");
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    @Order(value=0x7FFFFFFF)
    public void onEvent(MainContextRefreshedEvent event) {
        Map map = event.getApplicationContext().getBeansOfType(DuibaRocketmqListenerContainer.class);
        if (map.isEmpty()) {
            return;
        }
        for (DuibaRocketmqListenerContainer container : map.values()) {
            if (!container.isRunning()) {
                try {
                    container.start();
                }
                catch (Exception e) {
                    log.error("Started container failed. {}", (Object)container, (Object)e);
                }
            }
            this.containers.put(container.getConsumerProperties().getGroup(), container);
        }
    }

    public ConsumerProperties getConsumerPropertiesByGroup(String group) {
        return this.consumerPropertiesMap.get(group);
    }

    public DuibaRocketmqListenerContainer getContainerByGroup(String group) {
        return this.containers.get(group);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

