/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQPushConsumerLifecycleListener;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class DefaultRocketMQListenerContainer
implements InitializingBean,
RocketMQListenerContainer,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DefaultRocketMQListenerContainer.class);
    private long suspendCurrentQueueTimeMillis = 1000L;
    private int delayLevelWhenNextConsume = 0;
    private String nameServer;
    private String consumerGroup;
    private String topic;
    private int consumeThreadMax = 64;
    private String charset = "UTF-8";
    private ObjectMapper objectMapper;
    private RocketMQListener rocketMQListener;
    private RocketMQMessageListener rocketMQMessageListener;
    private DefaultMQPushConsumer consumer;
    private Class messageType;
    private boolean running;
    private ConsumeMode consumeMode;
    private SelectorType selectorType;
    private String selectorExpression;
    private org.apache.rocketmq.spring.annotation.MessageModel messageModel;

    public long getSuspendCurrentQueueTimeMillis() {
        return this.suspendCurrentQueueTimeMillis;
    }

    public void setSuspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
        this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
    }

    public int getDelayLevelWhenNextConsume() {
        return this.delayLevelWhenNextConsume;
    }

    public void setDelayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
        this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public RocketMQListener getRocketMQListener() {
        return this.rocketMQListener;
    }

    public void setRocketMQListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public RocketMQMessageListener getRocketMQMessageListener() {
        return this.rocketMQMessageListener;
    }

    public void setRocketMQMessageListener(RocketMQMessageListener anno) {
        this.rocketMQMessageListener = anno;
        this.consumeMode = anno.consumeMode();
        this.consumeThreadMax = anno.consumeThreadMax();
        this.messageModel = anno.messageModel();
        this.selectorExpression = anno.selectorExpression();
        this.selectorType = anno.selectorType();
    }

    public ConsumeMode getConsumeMode() {
        return this.consumeMode;
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public org.apache.rocketmq.spring.annotation.MessageModel getMessageModel() {
        return this.messageModel;
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public void setupMessageListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
        }
        this.setRunning(true);
        log.info("running container: {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.consumer)) {
                this.consumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initRocketMQPushConsumer();
        this.messageType = this.getMessageType();
        log.debug("RocketMQ messageType: {}", (Object)this.messageType.getName());
    }

    public String toString() {
        return "DefaultRocketMQListenerContainer{consumerGroup='" + this.consumerGroup + '\'' + ", nameServer='" + this.nameServer + '\'' + ", topic='" + this.topic + '\'' + ", consumeMode=" + (Object)((Object)this.consumeMode) + ", selectorType=" + (Object)((Object)this.selectorType) + ", selectorExpression='" + this.selectorExpression + '\'' + ", messageModel=" + (Object)((Object)this.messageModel) + '}';
    }

    private Object doConvertMessage(MessageExt messageExt) {
        if (Objects.equals(this.messageType, MessageExt.class)) {
            return messageExt;
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(this.messageType, String.class)) {
            return str;
        }
        try {
            return this.objectMapper.readValue(str, this.messageType);
        }
        catch (Exception e) {
            log.info("convert failed. str:{}, msgType:{}", (Object)str, (Object)this.messageType);
            throw new RuntimeException("cannot convert message to " + this.messageType, e);
        }
    }

    private Class getMessageType() {
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)this.rocketMQListener);
        Type[] interfaces = targetClass.getGenericInterfaces();
        Class superclass = targetClass.getSuperclass();
        while ((Objects.isNull(interfaces) || 0 == interfaces.length) && Objects.nonNull(superclass)) {
            interfaces = superclass.getGenericInterfaces();
            superclass = targetClass.getSuperclass();
        }
        if (Objects.nonNull(interfaces)) {
            for (Type type : interfaces) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !Objects.equals((parameterizedType = (ParameterizedType)type).getRawType(), RocketMQListener.class)) continue;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (Objects.nonNull(actualTypeArguments) && actualTypeArguments.length > 0) {
                    return (Class)actualTypeArguments[0];
                }
                return Object.class;
            }
            return Object.class;
        }
        return Object.class;
    }

    private void initRocketMQPushConsumer() throws MQClientException {
        Assert.notNull((Object)this.rocketMQListener, (String)"Property 'rocketMQListener' is required");
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup);
        this.consumer.setNamesrvAddr(this.nameServer);
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        if (this.consumeThreadMax < this.consumer.getConsumeThreadMin()) {
            this.consumer.setConsumeThreadMin(this.consumeThreadMax);
        }
        switch (this.messageModel) {
            case BROADCASTING: {
                this.consumer.setMessageModel(MessageModel.BROADCASTING);
                break;
            }
            case CLUSTERING: {
                this.consumer.setMessageModel(MessageModel.CLUSTERING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'messageModel' was wrong.");
            }
        }
        switch (this.selectorType) {
            case TAG: {
                this.consumer.subscribe(this.topic, this.selectorExpression);
                break;
            }
            case SQL92: {
                this.consumer.subscribe(this.topic, this.selectorExpression);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'selectorType' was wrong.");
            }
        }
        switch (this.consumeMode) {
            case ORDERLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerOrderly());
                break;
            }
            case CONCURRENTLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'consumeMode' was wrong.");
            }
        }
        if (this.rocketMQListener instanceof RocketMQPushConsumerLifecycleListener) {
            ((RocketMQPushConsumerLifecycleListener)((Object)this.rocketMQListener)).prepareStart(this.consumer);
        }
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.rocketMQListener.onMessage(DefaultRocketMQListenerContainer.this.doConvertMessage(messageExt));
                    long costTime = System.currentTimeMillis() - now;
                    log.info("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageExt:{}", (Object)messageExt, (Object)e);
                    context.setSuspendCurrentQueueTimeMillis(DefaultRocketMQListenerContainer.this.suspendCurrentQueueTimeMillis);
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
            return ConsumeOrderlyStatus.SUCCESS;
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.rocketMQListener.onMessage(DefaultRocketMQListenerContainer.this.doConvertMessage(messageExt));
                    long costTime = System.currentTimeMillis() - now;
                    log.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageExt:{}", (Object)messageExt, (Object)e);
                    context.setDelayLevelWhenNextConsume(DefaultRocketMQListenerContainer.this.delayLevelWhenNextConsume);
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

