/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq;

import cn.com.duibaboot.ext.stream.binder.Binder;
import cn.com.duibaboot.ext.stream.binder.BinderMessageHandler;
import cn.com.duibaboot.ext.stream.binder.BinderMessageProducer;
import cn.com.duibaboot.ext.stream.config.BindingProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.rocketmq.consuming.RocketMQListenerBindingContainer;
import org.springframework.cloud.stream.binder.rocketmq.integration.RocketMQInboundChannelAdapter;
import org.springframework.cloud.stream.binder.rocketmq.integration.RocketMQMessageHandler;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class RocketMQMessageChannelBinder
implements Binder {
    private InstrumentationManager instrumentationManager;
    private ApplicationContext applicationContext;
    private ObjectMapper objectMapper;

    public BinderMessageHandler createProducerMessageHandler(BindingProperties bindingProperties) {
        String producerGroup = bindingProperties.getProducer().getGroup();
        if (StringUtils.isEmpty((Object)producerGroup)) {
            throw new RuntimeException("'group must be configured for channel");
        }
        RocketMQProducerProperties producerProperties = (RocketMQProducerProperties)bindingProperties.getProducer().bindProperties(RocketMQProducerProperties.class);
        RocketMQTemplate rocketMqTemplate = new RocketMQTemplate();
        rocketMqTemplate.setObjectMapper(this.objectMapper);
        DefaultMQProducer producer = new DefaultMQProducer(producerGroup);
        producer.setVipChannelEnabled(producerProperties.getVipChannelEnabled().booleanValue());
        producer.setNamesrvAddr(producerProperties.getNameServer());
        producer.setSendMsgTimeout(producerProperties.getSendMessageTimeout());
        producer.setRetryTimesWhenSendFailed(producerProperties.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerProperties.getRetryTimesWhenSendAsyncFailed());
        producer.setCompressMsgBodyOverHowmuch(producerProperties.getCompressMessageBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerProperties.isRetryNextServer());
        producer.setMaxMessageSize(producerProperties.getMaxMessageSize().intValue());
        producer.setInstanceName(bindingProperties.getBindingName() + "Producer");
        rocketMqTemplate.setProducer(producer);
        RocketMQMessageHandler messageHandler = new RocketMQMessageHandler(rocketMqTemplate, producerGroup, this.instrumentationManager);
        messageHandler.setBeanFactory((BeanFactory)this.applicationContext);
        messageHandler.setSync(producerProperties.getSync());
        return messageHandler;
    }

    public BinderMessageProducer createConsumerEndpoint(BindingProperties bindingProperties) {
        String group = bindingProperties.getConsumer().getGroup();
        if (group == null || "".equals(group)) {
            throw new RuntimeException("'group must be configured for channel ");
        }
        String topic = bindingProperties.getConsumer().getTopic();
        RocketMQConsumerProperties consumerProperties = (RocketMQConsumerProperties)bindingProperties.getConsumer().bindProperties(RocketMQConsumerProperties.class);
        RocketMQListenerBindingContainer listenerContainer = new RocketMQListenerBindingContainer(consumerProperties);
        listenerContainer.setConsumerGroup(group);
        listenerContainer.setTopic(topic);
        listenerContainer.setConcurrency(bindingProperties.getConsumer().getConcurrency());
        listenerContainer.setSuspendCurrentQueueTimeMillis(consumerProperties.getSuspendCurrentQueueTimeMillis());
        listenerContainer.setDelayLevelWhenNextConsume(consumerProperties.getDelayLevelWhenNextConsume());
        listenerContainer.setNameServer(consumerProperties.getNameServer());
        listenerContainer.setInstanceName(bindingProperties.getBindingName());
        return new RocketMQInboundChannelAdapter(listenerContainer, this.instrumentationManager);
    }

    public void setInstrumentationManager(InstrumentationManager instrumentationManager) {
        this.instrumentationManager = instrumentationManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

