package cn.com.duibaboot.ext.stream.binding;

import cn.com.duibaboot.ext.stream.binder.BinderMessageHandler;
import cn.com.duibaboot.ext.stream.channel.ProducerMessageChannel;
import lombok.extern.slf4j.Slf4j;

/**
 * @author liuyao
 */
@Slf4j
public class ProducerBinding extends AbstructBinding {

    @Override
    public void doBinding() {
        try{
            ProducerMessageChannel producerMessageChannel = (ProducerMessageChannel)getMessageChannel();
            BinderMessageHandler messageHandler = (BinderMessageHandler)getMessageHandler();
            //构建关系
            producerMessageChannel.setMessageHandler(messageHandler);
            messageHandler.start();
        }catch (Exception e){
            log.error("发布器初始化失败",e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try{
            BinderMessageHandler messageHandler = (BinderMessageHandler)getMessageHandler();
            messageHandler.stop();
        }catch (Exception e){
            log.error("发布器关闭失败",e);
            throw new RuntimeException(e);
        }

    }

}
