package cn.com.duibaboot.ext.stream.binding;

import cn.com.duibaboot.ext.stream.binder.BinderMessageProducer;
import lombok.extern.slf4j.Slf4j;

/**
 * @author liuyao
 */
@Slf4j
public class SubscribableBinding extends AbstructBinding {

    private BinderMessageProducer messageProducer;

    @Override
    public void doBinding() {
        try {
            messageProducer.setOutputChannel(getMessageChannel());
            messageProducer.init();
        }catch (Exception e){
            log.error("绑定器启动失败",e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try{
            messageProducer.stopListener();
        }catch (Exception e){
            log.error("绑定器停止失败",e);
        }
    }

    public void setMessageProducer(BinderMessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

}
