/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba;

import cn.com.duiba.utils.ClassUtils;
import cn.com.duiba.utils.JarUtils;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CheckJars {
    public static List<String> check(List<File> files) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (File file : files) {
            List<String> packages = JarUtils.getJarPackages(file.getAbsolutePath());
            for (String pp : packages) {
                String pPath = StringUtils.replace((String)pp, (String)"/", (String)".");
                if (pPath.endsWith(".")) {
                    pPath = pPath.substring(0, pPath.length() - 1);
                }
                List<Class<?>> classes = ClassUtils.getClassList(pPath, false);
                for (Class<?> clazz : classes) {
                    multimap.put((Object)clazz.getName(), (Object)file.getAbsolutePath());
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String className : multimap.keys()) {
            Collection coll = multimap.get((Object)className);
            ArrayList list = new ArrayList(coll);
            if (list.size() <= 1) continue;
            result.add(String.format("\r\nclassName: %s, \u53d1\u751f\u51b2\u7a81\uff0cjar\u8def\u5f84\u4e3a: %s", className, list));
        }
        return result;
    }

    public static void main(String[] args) {
        File file = new File("/Users/gyf/.m2/repository/commons-lang/commons-lang/2.6/commons-lang-2.6.jar");
        File file1 = new File("/Users/gyf/.m2/repository/commons-lang/commons-lang/2.5/commons-lang-2.5.jar");
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        files.add(file1);
        System.out.println(CheckJars.check(files));
    }
}

