/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;

public class ClassUtils {
    private static final String CLASS_POSTFIX = ".class";

    public static List<Class<?>> getClassList(String pkgName, boolean isRecursive) {
        ArrayList classList = new ArrayList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String strFile = StringUtils.replace((String)pkgName, (String)".", (String)"/");
            Enumeration<URL> urls = loader.getResources(strFile);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String pkgPath = url.getPath();
                    ClassUtils.findClassName(classList, pkgName, isRecursive, pkgPath);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                ClassUtils.findClassName(classList, pkgName, isRecursive, url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classList;
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, boolean isRecursive, String pkgPath) {
        File[] files;
        if (clazzList == null) {
            return;
        }
        for (File f : files = ClassUtils.filterClassFiles(pkgPath)) {
            String fileName = f.getName();
            if (f.isFile()) {
                String clazzName = ClassUtils.getClassName(pkgName, fileName);
                ClassUtils.addClassName(clazzList, clazzName);
                continue;
            }
            if (!isRecursive) continue;
            String subPkgName = pkgName + "." + fileName;
            String subPkgPath = pkgPath + "/" + fileName;
            ClassUtils.findClassName(clazzList, subPkgName, true, subPkgPath);
        }
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, boolean isRecursive, URL url) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            String clazzName = jarEntryName.replace("/", ".");
            int endIndex = clazzName.lastIndexOf(46);
            String prefix = null;
            if (endIndex > 0) {
                String prefix_name = clazzName.substring(0, endIndex);
                if (clazzName.endsWith(CLASS_POSTFIX)) {
                    clazzName = prefix_name;
                }
                if ((endIndex = prefix_name.lastIndexOf(46)) > 0) {
                    prefix = prefix_name.substring(0, endIndex);
                }
            }
            if (prefix == null || !jarEntryName.endsWith(CLASS_POSTFIX) || !prefix.equals(pkgName) && (!isRecursive || !prefix.startsWith(pkgName))) continue;
            ClassUtils.addClassName(clazzList, clazzName);
        }
    }

    private static File[] filterClassFiles(String pkgPath) {
        if (pkgPath == null) {
            return new File[0];
        }
        return new File(pkgPath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(ClassUtils.CLASS_POSTFIX) || file.isDirectory();
            }
        });
    }

    private static String getClassName(String pkgName, String fileName) {
        int endIndex = fileName.lastIndexOf(46);
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = pkgName + "." + clazz;
        }
        return clazzName;
    }

    private static void addClassName(List<Class<?>> clazzList, String clazzName) {
        if (clazzList != null && clazzName != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (clazz != null) {
                clazzList.add(clazz);
            }
        }
    }

    public static void main(String[] args) {
        List<Class<?>> classes = ClassUtils.getClassList("org.apache.commons.logging.impl", false);
        for (Class<?> it : classes) {
            System.out.println(it.getName());
        }
    }
}

