package cn.com.duiba.cloud.duiba.activity.service.api.exception;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @ClassName ApiException
 * @Description api统一异常类
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/8/12 11:22 上午
 * @Version 1.0
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiException extends RuntimeException {
    private static final long serialVersionUID = -2672689515541437487L;
    private static final String ERROR_CODE = Errors.SYS_ERROR.getCode();

    private String code = ERROR_CODE;
    private Object data;

    /**
     * 是否需要warn级别日志输出，默认info级别
     */
    private boolean outWarnLog = false;

    public ApiException(String msg) {
        super(msg);
    }

    public ApiException(String msg, boolean outWarnLog) {
        super(msg);
        this.outWarnLog = outWarnLog;
    }

    public ApiException(Exception e) {
        super(e);
    }

    public ApiException(Error<String> error) {
        this(error.getDesc());
        this.code = error.getCode();
    }

    public ApiException(String msg, String code) {
        super(msg);
        this.code = code;
    }

    public ApiException(String msg, String code, boolean outWarnLog) {
        super(msg);
        this.code = code;
        this.outWarnLog = outWarnLog;
    }

    public ApiException(String msg, String code, Object data) {
        super(msg);
        this.code = code;
        this.data = data;
    }

    public ApiException(Error<String> error, Object data) {
        this(error);
        this.data = data;
    }
}