package cn.com.duiba.cloud.duiba.activity.service.api.exception;

/**
 * @InterfaceName Errors
 * @Description 系统错误
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/8/12 2:00 下午
 * @Version 1.0
 **/
public interface Errors {
    /**
     * 默认成功码
     */
    ErrorMeta SUCCESS = new ErrorMeta("0000000000", "success");

    /**
     * 未知异常
     */
    ErrorMeta UNKNOWN = new ErrorMeta("-9", "未知异常");

    /**
     * 默认错误码
     */
    ErrorMeta SYS_ERROR = new ErrorMeta("1000000000", "系统错误");

    /**
     * 序列化格式不存在
     */
    ErrorMeta NO_FORMATTER = new ErrorMeta("1000000001", "序列化格式不存在");

    /**
     * 不支持contectType
     */
    ErrorMeta NO_CONTECT_TYPE_SUPPORT = new ErrorMeta("1000000002", "不支持contectType");

    /**
     * 调用不存在的服务请求
     */
    ErrorMeta NO_API = new ErrorMeta("1000000003", "不存在的服务请求");

    /**
     * 参数非法
     */
    ErrorMeta ERROR_PARAM = new ErrorMeta("1000000004", "参数非法");

    /**
     * json格式错误
     */
    ErrorMeta ERROR_JSON_DATA = new ErrorMeta("1000000005", "json格式错误");

    /**
     * 业务参数错误
     */
    ErrorMeta BUSI_PARAM_ERROR = new ErrorMeta("1000000006", "业务参数错误");

    /**
     * 请求超时
     */
    ErrorMeta TIMEOUT = new ErrorMeta("1000000007", "请求超时");

    /**
     * 请求时间格式错误
     */
    ErrorMeta TIME_INVALID = new ErrorMeta("1000000008", "请求时间格式错误");

    /**
     * jwt过期
     */
    ErrorMeta ERROR_JWT_EXPIRED = new ErrorMeta("1000000009", "jwt过期");

    /**
     * jwt错误
     */
    ErrorMeta ERROR_JWT = new ErrorMeta("1000000010", "jwt错误");

    /**
     * jwt错误
     */
    ErrorMeta UP = new ErrorMeta("1000000010", "jwt错误");

    /**
     * 校验参数错误
     */
    ErrorMeta VALIDATION_ERROR = new ErrorMeta("1000000011", "校验出错");

    /**
     * C端未登录
     */
    ErrorMeta ERROR_API_NOT_LOGIN = new ErrorMeta("1000000012", "未登录，请先登录");

    /**
     * B端无权操作
     */
    ErrorMeta ERROR_CMD_NO_PERMISSION = new ErrorMeta("1000000013", "无权操作");
}