package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;

import java.util.List;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动服务
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 保存
     * @param dto
     * @return
     */
    Long save(MallActivityDTO dto);

    /**
     * 修改
     * @param dto
     * @return
     */
    Boolean updateById(MallActivityDTO dto);

    MallActivityDTO getByActivityId(Long activityId);

    /**
     * 删除活动
     * @param activityId
     * @return
     */
    Boolean delete(Long activityId);

    /**
     * 更新活动状态
     * @param activityId
     * @param status
     * @return
     */
    Boolean updateStatus(Long activityId,Integer status);

    /**
     * 分页查询
     * @param page
     * @param dto
     * @return
     */
    Page<MallActivityDTO> page(Page page, MallActivityDTO dto);



}
