package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 领取状态枚举
 *
 * @author zouwx
 * @date 2022/04/02
 */
@Getter
public enum ReceiveStatusEnum {

    /**
     * 领取状态:1-待领取 2-已领取 3-失败 4-已过期
     * 已领取之后是订单状态
     */
    UNCLAIMED(1,"待领取"),

    RECEIVE(2,"已领取"),

    FAIL(3,"失败"),

    DUE(4,"已过期"),
    ;

    private Integer type;

    private String desc;

    ReceiveStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ReceiveStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ReceiveStatusEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static ReceiveStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
