package cn.com.duiba.cloud.duiba.activity.service.api.enums;

/**
 * @author zhengjianhao
 * @date 2022/4/1
 * @description 来源渠道枚举
 */
public enum SourceTerminalType {
	APP(1,  "app", "app"),
	WECHAT(2, "wechat",  "微信"),
	WECHAT_MINI_PROGRAM(3, "wechatMiniProgram",  "微信小程序"),
	;

	private int id;
	private String code;
	private String desc;

	SourceTerminalType(int id, String code, String desc) {
		this.id = id;
		this.code = code;
		this.desc = desc;
	}

	public int getId() {
		return id;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	public static SourceTerminalType getById(Integer typeId){
		if(null == typeId){
			return null;
		}
		for(SourceTerminalType sourceTerminalType: SourceTerminalType.values()){
			if(sourceTerminalType.getId() == typeId){
				return sourceTerminalType;
			}
		}
		return null;
	}
}
