package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.StrategyResult;

/**
 * @author zhengjianhao
 * @date 2022/4/1
 * @description 通用发奖api
 */
@AdvancedFeignClient
public interface RemoteStrategyService {

	/**
	 * 通用概率出奖
	 * @param activityId 活动id
	 * @param ruleCode 发奖规则code
	 * @param consumerId 抽奖用户
	 * @param directly 是否直接出奖：是，直接创建订单；不是，不创建订单，需要用户手动领取
	 * @param sourceTerminal 来源渠道：1，app；2，微信；3，微信小程序
	 *      @see cn.com.duiba.cloud.duiba.activity.service.api.enums.SourceTerminalType
	 * @return
	 */
	StrategyResult sendProbability(Long activityId, String ruleCode, Long consumerId, boolean directly, Integer sourceTerminal) throws BizException;

}
