package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayQuerytableDTO;
import cn.com.duiba.wolf.entity.Pair;

import java.util.List;

@AdvancedFeignClient
public interface RemoteQueryTableService {

    /**
     * 插入
     */
    void add(PlaywayQuerytableDTO dto);

    boolean updateById(Long activityId, String group, long id, PlaywayQuerytableDTO dto);

    boolean deleteById(Long activityId, String group, long id);

    boolean increase(Long activityId, String group, long id, long delta, long max);

    /**
     * @param activityId
     * @param queryList
     * @param sortField 排序字段
     * @param  sortType 排序类型 1：DESC 2：ASC
     * @param pageNum   从0开始计算
     * @param pageSize
     * @return
     */
    List<PlaywayQuerytableDTO> query(Long activityId, String group, List<Pair<Integer, Object>> queryList,
                                    int sortField, int sortType,
                                    long pageNum, long pageSize);

    /**
     * query
     * @param activityId 项目ID
     * @param group 分组
     * @param queryList 字段
     * @param pageNum 第几页
     * @param pageSize 每页大小
     * @return
     */
    List<PlaywayQuerytableDTO> query(Long activityId, String group, List<Pair<Integer, Object>> queryList,
                                    long pageNum, long pageSize);

    List<PlaywayQuerytableDTO> batchQuery(Long activityId, String group, int type, List<Object> values);

    long count(Long activityId, String group, List<Pair<Integer, Object>> queryList);


    /**
     * 模糊查询
     */
    List<PlaywayQuerytableDTO> inexplicitQuery(Long activityId, String group, List<Pair<Integer, Object>> queryList,
                                              int sortField, int sortType,
                                              long pageNum, long pageSize);

    /**
     * 模糊查询
     * @param activityId 项目id
     * @param group 分组
     * @param queryList 字段
     * @param pageNum 第几页
     * @param pageSize 每页大小
     * @return
     */
    List<PlaywayQuerytableDTO> inexplicitQuery(Long activityId, String group, List<Pair<Integer, Object>> queryList,
                                              long pageNum, long pageSize);
    /**
     * 模糊查询
     *
     * @param activityId
     * @param group
     * @param queryList
     * @return
     */
    long inexplicitCount(Long activityId, String group, List<Pair<Integer, Object>> queryList);
}
