package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @date:2022/3/29 14:04
 * @author:zhaozhanghai
 * @Description: 奖品相关枚举
 */
@Getter
@AllArgsConstructor
public enum PrizeEnum {
    //概率类型：1，普通概率；2，替补必中 百分百
    probability_type_common(1,"1 普通概率"),
    probability_type_absolutely(2,"2 替补必中 百分百"),

    //奖品规则：1商品，2道具 3谢谢参与
    prize_type_goods(1,"1商品"),
    prize_type_prop(2,"2道具"),
    prize_type_thanks(3,"3谢谢参与"),


;



    private Integer type;
    private String desc;

    /**
     * 根据奖品类型判断是否中奖
     * @param prizeType
     *  true：中奖
     *  false：未中奖
     * @return
     */
    public static boolean checkWinPrize(Integer prizeType){
        return !(null == prizeType || prizeType.equals(PrizeEnum.prize_type_thanks.getType()));
    }

}
