package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.scoring;

import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.AbstractPlayWay;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.annotation.Preinstall;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayActionRecordDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.enums.PlaywayEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote.RemoteActionRecordService;
import org.springframework.beans.factory.annotation.Autowired;

@Preinstall
public abstract class AbstractScoringPlayWay extends AbstractPlayWay {

    @Autowired
    protected ScoringUserRequestApi scoringUserRequestApi;
    @Autowired
    private RemoteActionRecordService remoteActionRecordService;

    /**
     * 如允许开始游戏，请调用 startNow() 获得参与游戏的startId，并将startId返回给前端
     *
     * @return
     */
    public abstract Object start();

    /**
     * @param startId
     * @return Object
     */
    public abstract Object submit(Long startId, Integer score);


    protected Long startNow(Long activityId, String playwayId, Long consumerId, String extra){
        PlaywayActionRecordDTO actionRecordDTO = new PlaywayActionRecordDTO();
        actionRecordDTO.setActivityId(activityId);
        actionRecordDTO.setPlaywayId(playwayId);
        actionRecordDTO.setUserId(consumerId);
        actionRecordDTO.setExtra(extra);
        return remoteActionRecordService.addRecord(actionRecordDTO);
    }

    @Override
    protected PlaywayEnum getPlayWay() {
        return PlaywayEnum.SCORING;
    }
}
