package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/4/1 11:39
 * @author:zhaozhanghai
 * @Description: 活动发奖规则
 */
@Data
public class BaseRuleVo implements Serializable {

    /**
     * 规则code
     */
    private String ruleCode;
    /**
     * 用户分层出奖 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "用户分层出奖类型错误")
    private Integer isIdentityLayeredPrize;

    /**
     * 多奖项中奖限制开启 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "多奖项中奖限制开启类型错误")
    private Integer isMorePrize;

    /**
     * 多奖项配置
     */
    private BaseMorePrizeVo morePrize;

    /**
     * 百分百中奖开启 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "百分百中奖开启类型错误")
    private Integer absolutelyPrize;
    /**
     * 概率出奖奖品配置
     */
    @NotEmpty(message = "奖品数量不能为空")
    private List<BasePrizeVo> prizeList;
    /**
     * 百分百出奖奖品配置
     */
    private List<BasePrizeVo> absolutelyPrizeList;

    /**
     * 奖品扩展字段
     */
    private String ext;

}
