package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.rank;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 排行榜规则配置
 *
 * @author zouwx
 * @date 2022/04/08
 */
@Data
public class RankRuleConfigVO implements Serializable {

    private static final long serialVersionUID = 5723332011732002988L;

    /**
     * 游戏难度
     */
    @NotNull(message = "游戏难度不能为空")
    private Integer gameDifficulty;

    /**
     * 单局游戏时常
     */
    @NotNull(message = "单局游戏时长不能为空")
    private Integer singleTime;

    /**
     * 是否开启复活
     */
    private Integer enableResurgence;

    /**
     * 积分复活
     */
    private Integer scoreResurgence;

    /**
     * 概率复活
     */
    private Integer probabilityResurgence;

    /**
     * 复活积分
     */
    private Integer resurgenceIntegral;

    /**
     * 积分复活上限
     */
    private Integer resurgenceIntegralLimit;

    /**
     * 单次复活概率
     */
    private Integer singleResurgenceProbability;

    /**
     * 概率复活上限
     */
    private Integer resurgenceProbabilityLimit;

    /**
     * 是否开启概率出奖
     */
    private Integer probabilityPrize;

    /**
     * 是否开启排行榜出奖
     */
    private Integer rankPrize;
}
