package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipConfDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Comparator;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/4/12
 * @description
 */
public class ConsumerVipLevelUtil {

	public static String getVipLevel(ConsumerDTO consumerDTO, String vipTypeName, List<MallAppVipConfDTO> vipConfDTOList) {
		// 获取vip分组
		MallAppVipConfDTO mallAppVipConfDTO = getVipType(vipTypeName, vipConfDTOList);

		// 获取免登传过来的vip等级
		String gradeDevTag;
		if (null == consumerDTO) {
			gradeDevTag = null;
		}else {
			gradeDevTag = consumerDTO.getVipLevelByType(vipTypeName);
		}

		// 校验vip等级并返回
		return checkVipLevel(gradeDevTag, mallAppVipConfDTO);
	}

	/**
	 * 获取vip分组
	 * @param vipTypeName
	 * @param vipConfDTOList
	 * @return
	 */
	private static MallAppVipConfDTO getVipType(String vipTypeName, List<MallAppVipConfDTO> vipConfDTOList){
		// 获取分组
		if(CollectionUtils.isEmpty(vipConfDTOList)){
			return null;
		}
		MallAppVipConfDTO mallAppVipConfDTO;
		if (StringUtils.isBlank(vipTypeName) || vipConfDTOList.stream().noneMatch(x -> vipTypeName.equals(x.getVipTypeName()))) {
			mallAppVipConfDTO = vipConfDTOList.get(0);
		} else {
			mallAppVipConfDTO = vipConfDTOList.stream().filter(x -> vipTypeName.equals(x.getVipTypeName())).findFirst().orElse(null);
		}
		return mallAppVipConfDTO;
	}

	/**
	 * 根据免登传入的vip等级进行校验，如果有效，直接返回；如果无效，返回默认vip等级
	 * @param gradeDevTag
	 * @param mallAppVipConfDTO
	 * @return
	 */
	private static String checkVipLevel(String gradeDevTag, MallAppVipConfDTO mallAppVipConfDTO){
		// 匹配等级
		if(null == mallAppVipConfDTO){
			return gradeDevTag;
		}
		List<MallAppVipGradeDTO> gradeDTOList = JSON.parseArray(mallAppVipConfDTO.getVipLevelConfig(), MallAppVipGradeDTO.class);
		if (CollectionUtils.isEmpty(gradeDTOList)) {
			return gradeDevTag;
		}
		// 如果不匹配，则返回默认vip等级
		if (StringUtils.isBlank(gradeDevTag) || gradeDTOList.stream().noneMatch(x -> gradeDevTag.equals(x.getDevTag()))) {
			gradeDTOList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade));
			return gradeDTOList.get(0).getDevTag();
		} else {
			return gradeDevTag;
		}
	}
}
