/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.enums.task;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public enum TaskCycleUnitEnum implements IEnum<Integer>
{
    DAY(1, "\u6bcf\u65e5"),
    WEEK(2, "\u6bcf\u5468"),
    MONTH(3, "\u6bcf\u6708"),
    YEAR(4, "\u6bcf\u5e74");

    private final Integer taskCycleUnit;
    private final String desc;

    private TaskCycleUnitEnum(Integer taskCycleUnit, String desc) {
        this.taskCycleUnit = taskCycleUnit;
        this.desc = desc;
    }

    public Integer getTaskCycleUnit() {
        return this.taskCycleUnit;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getDbCode() {
        return this.getTaskCycleUnit();
    }

    public static Long calculateNaturalPeriodBetween(TaskCycleUnitEnum taskCycleUnitEnum, LocalDate startDate, LocalDate endDate) {
        Long between = null;
        switch (taskCycleUnitEnum) {
            case DAY: {
                between = ChronoUnit.DAYS.between(startDate, endDate);
                break;
            }
            case WEEK: {
                between = ChronoUnit.WEEKS.between(TaskCycleUnitEnum.convert2Monday(startDate), endDate);
                break;
            }
            case MONTH: {
                between = ChronoUnit.MONTHS.between(startDate.withDayOfMonth(1), endDate.withDayOfMonth(1));
                break;
            }
            case YEAR: {
                between = ChronoUnit.YEARS.between(startDate.withDayOfYear(1), endDate.withDayOfYear(1));
                break;
            }
        }
        return between;
    }

    private static LocalDate convert2Monday(LocalDate localDate) {
        LocalDate result = localDate;
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        switch (dayOfWeek) {
            case MONDAY: {
                result = localDate.minusDays(0L);
                break;
            }
            case TUESDAY: {
                result = localDate.minusDays(1L);
                break;
            }
            case WEDNESDAY: {
                result = localDate.minusDays(2L);
                break;
            }
            case THURSDAY: {
                result = localDate.minusDays(3L);
                break;
            }
            case FRIDAY: {
                result = localDate.minusDays(4L);
                break;
            }
            case SATURDAY: {
                result = localDate.minusDays(5L);
                break;
            }
            case SUNDAY: {
                result = localDate.minusDays(6L);
                break;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        LocalDate startDate = LocalDate.now();
        for (int i = 0; i < 3670; ++i) {
            LocalDate endDate = startDate.plusDays(i);
            System.out.println(startDate);
            System.out.println(endDate);
            for (TaskCycleUnitEnum taskCycleUnitEnum : TaskCycleUnitEnum.values()) {
                System.out.println((Object)((Object)taskCycleUnitEnum) + ":" + TaskCycleUnitEnum.calculateNaturalPeriodBetween(taskCycleUnitEnum, startDate, endDate));
            }
        }
    }
}

