package cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述： 积分商城活动趋势数据
 *
 * @Auther: xiaotian
 * @Date: 2022/4/14 10:12
 * @Description:
 */
@Data
public class ActivityTrendDataDTO implements Serializable {
    private static final long serialVersionUID = 6718719617433014851L;

    /**
     * 活动Id
     */
    private Long activityId;

    /**
     * 数据时间
     */
    private Date curDate;

    /**
     * 统计维度 1:新访客 2:老访客
     */
    private Integer itemScope;

    /**
     * 活动访问次数
     */
    private Long visitPv;

    /**
     * 活动访问人数
     */
    private Long visitUv;

    /**
     * 参与活动次数
     */
    private Long joinPv;

    /**
     * 参数活动人数
     */
    private Long joinUv;

    /**
     * 消耗积分数
     */
    private Long costPoint;

    /**
     * 消耗积分人数
     */
    private Long costPointPerCount;

    /**
     * 分享活动次数
     */
    private Long sharePv;

    /**
     * 分享活动人数
     */
    private Long shareUv;

    /**
     * 邀请发起次数（总数）
     */
    private Long invitePv;

    /**
     * 邀请发起人数
     */
    private Long inviteUv;

    /**
     * 助力次数
     */
    private Long helpPv;

    /**
     * 助力人数
     */
    private Long helpUv;

    /**
     * 中奖人数
     */
    private Long winCount;

    /**
     * 领奖人数
     */
    private Long drawCount;

    /**
     * 总访问时长
     */
    private Long sumVisitTime;

    /**
     * 总游戏时长
     */
    private Long sumGameTime;

    /**
     * 分享页访问次数
     */
    private Long shareVisitPv;

    /**
     * 分享页访问人数
     */
    private Long shareVisitUv;


}
