package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 排行榜开奖状态
 *
 * @author zouwx
 * @date 2022/04/15
 */
@Getter
public enum RankOpStatusEnum {

    /**
     * 规则条件状态
     */
    NONE(0, "无需开奖"),
    NOT_LOTTERY(1, "未开奖"),
    IN_LOTTERY(2, "开奖中"),
    ERROR_LOTTERY(3, "开奖异常"),
    SUCCESS_LOTTERY(4, "已开奖"),
    ;

    private Integer type;

    private String desc;

    RankOpStatusEnum(Integer type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    private static final Map<Integer, RankOpStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (RankOpStatusEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static RankOpStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
