package cn.com.duiba.cloud.duiba.activity.service.api.enums.seckill;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * 秒杀活动状态
 */
public enum SeckillActStatusEnum implements IEnum<Integer> {
    ON(0, "有效"),
    OFF(10, "已失效"),
    ;

    private final Integer actStatus;
    private final String desc;

    SeckillActStatusEnum(Integer actStatus, String desc) {
        this.actStatus = actStatus;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    @Override
    public Integer getDbCode() {
        return getActStatus();
    }

    public Integer getActStatus() {
        return actStatus;
    }
}
