package cn.com.duiba.cloud.duiba.activity.service.api.enums.task;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

public enum TaskSwitchEnum implements IEnum<Integer> {
    REWARD(0, "是否有奖励"),
    REWARD_BY_MANUAL(1, "是否手动领奖"),
    REWARD_AFTER_ALL(2, "是否全部完成后再发放奖励"),
    ;

    private final Integer taskSwitch;
    private final String desc;

    TaskSwitchEnum(Integer taskSwitch, String desc) {
        this.taskSwitch = taskSwitch;
        this.desc = desc;
    }

    public Integer getTaskSwitch() {
        return taskSwitch;
    }

    public String getDesc() {
        return desc;
    }

    @Override
    public Integer getDbCode() {
        return getTaskSwitch();
    }
}
