package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.seckill;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.seckill.SecKillActConfWithSkuConfAndDataDto;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.seckill.SeckillActConfDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.seckill.TakeSecKillChanceResultEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.param.seckill.SecKillActPageParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.seckill.SecKillActParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.Valid;
import java.util.List;

/**
 * 秒杀相关接口(面向B端/管理端)
 */
@AdvancedFeignClient
public interface RemoteSeckillService {

    /**
     * 翻页查询秒杀活动
     *
     * @return
     * @throws BizException
     */
    PageResponse<SeckillActConfDto> page(@Valid SecKillActPageParam param) throws BizException;

    /**
     * 秒杀活动详情
     *
     * @return
     * @throws BizException
     */
    SeckillActConfDto detail(@Valid SecKillActParam param) throws BizException;

    /**
     * 秒杀活动详情 带缓存
     * @return
     * @throws BizException
     */
    SeckillActConfDto detailByCache(SecKillActParam param) throws BizException;

    /**
     * 编辑秒杀活动
     *
     * @return
     * @throws BizException
     */
    Boolean edit(@Valid SecKillActParam param) throws BizException;

    /**
     * 创建秒杀活动
     *
     * @return
     * @throws BizException
     */
    Long create(@Valid SecKillActParam param) throws BizException;

    /**
     * 删除秒杀活动
     *
     * @return
     * @throws BizException
     */
    Boolean delete(@Valid SecKillActParam param) throws BizException;

    /**
     * 失效秒杀活动
     *
     * @return
     * @throws BizException
     */
    Boolean off(@Valid SecKillActParam param) throws BizException;

    /**
     * 获取秒杀机会
     * @param actId
     * @param appSkuId
     * @return
     */
    TakeSecKillChanceResultEnum takeSecKillChance(Long actId, Long appSkuId) throws BizException;

    /**
     * 回退秒杀机会
     * @param actId
     * @param secKillMillis
     * @param appSkuId
     * @return
     */
    void returnSecKillChance(Long actId, Long secKillMillis, Long appSkuId) throws BizException;

    /**
     * 组件活动列表
     * @param appId
     * @param idList
     * @return
     */
    List<SecKillActConfWithSkuConfAndDataDto> getListForUnit(Long appId, List<Long> idList);

    /**
     * 同步redis库存到数据库
     * @param actId
     * @param skuId
     * @throws BizException
     */
    void persistActSkuData(Long actId, Long skuId) throws BizException;
}
