/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public enum ActivityRuleKeyEnum {
    RULE_VIP_KEY("1_", "\u4f1a\u5458\u591a\u5956\u6c60\u914d\u7f6e\u524d\u7f00"),
    RULE_LABEL_KEY("2_", "\u6807\u7b7e\u591a\u5956\u6c60\u914d\u7f6e\u524d\u7f00");

    public static final String SPLIT = "_";
    public static final String ONE_FIELD_SPLIT = "_;_";
    public static final Integer SPLIT_SIZE;
    private String ruleKey;
    private String desc;
    private static final Map<String, ActivityRuleKeyEnum> ENUM_MAP;

    private ActivityRuleKeyEnum(String ruleCode, String desc) {
        this.ruleKey = ruleCode;
        this.desc = desc;
    }

    public static final boolean matchVip(String ruleKey, Integer userGrade) {
        if (StringUtils.isEmpty((String)ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(SPLIT);
        if (split.length < SPLIT_SIZE) {
            return false;
        }
        Integer configGrade = Integer.parseInt(split[1]);
        return Objects.equals(userGrade, configGrade);
    }

    public static final boolean verify(String ruleKey) {
        if (StringUtils.isEmpty((String)ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(SPLIT);
        return split.length < SPLIT_SIZE;
    }

    public static final boolean matchLabel(String ruleKey, Set<Long> labelIdSet) {
        if (StringUtils.isEmpty((String)ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(SPLIT);
        if (split.length < SPLIT_SIZE) {
            return false;
        }
        Long configLabelId = Long.parseLong(split[1]);
        return labelIdSet.contains(configLabelId);
    }

    public static final Triple<Boolean, Integer, Integer> isNewLimit(String keyword) {
        if (StringUtils.isEmpty((String)keyword)) {
            return Triple.of((Object)false, null, null);
        }
        String[] split = keyword.split(ONE_FIELD_SPLIT);
        if (split.length < SPLIT_SIZE) {
            return Triple.of((Object)false, null, null);
        }
        return Triple.of((Object)(split.length >= SPLIT_SIZE ? 1 : 0), (Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
    }

    public static ActivityRuleKeyEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        SPLIT_SIZE = 2;
        ENUM_MAP = new HashMap<String, ActivityRuleKeyEnum>();
        for (ActivityRuleKeyEnum tmp : ActivityRuleKeyEnum.values()) {
            ENUM_MAP.put(tmp.getRuleKey(), tmp);
        }
    }
}

