package cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangruofan
 * @date 2019/07/04
 */
@Data
public class ProjectxPrizeRecordDTO implements Serializable {

    private static final long serialVersionUID = 606716069749966742L;

    /**
     * 主键id，发奖记录id
     */
    private Long id;

    /**
     * 星速台项目id
     */
    private String projectId;

    /**
     * 兑吧用户id
     */
    private Long consumerId;

    /**
     * appid
     */
    private Long appId;

    /**
     * 发奖状态: 0，初始化；1，发奖中；2，待领取；3，领取中；4，已领取；5，领取失败；6，预期未领取
     *
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx.DrawStatusEnum
     */
    private Integer drawStatus;

    /**
     * 商品spuId
     */
    private Long itemId;

    /**
     * 奖品类型:  object，实物；coupon；卡券；virtual，充值；increase-credits，加积分
     *
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx.ProjectxPrizeTypeEnum
     */
    private String itemType;

    /**
     * 商品skuId
     */
    private Long skuId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeIcon;

    /**
     * 商品快照id
     */
    private String goodsSnapshotId;

    /**
     * 档位
     * 当奖品类型 increase-credits 时不能为空
     * 非必传
     */
    private String degree;

    /**
     * 开发者用户id
     */
    private String partnerUserId;

    /**
     * 星速台活动中奖记录id
     */
    private String projectOrderNo;

    /**
     * 开发者扣积分订单号
     * 如果有扣积分则传
     * 非必传
     */
    private String developerBizId;

    /**
     * 扣积分票据号：扣积分参与中奖时需要传
     */
    private String ticketNum;

    /**
     * 扩展信息
     */
    private String extra;

    /**
     * 下游下单订单号
     */
    private String orderNo;

    /**
     * 订单错误信息
     */
    private String msg;

}
