package cn.com.duiba.cloud.duiba.activity.service.api.dto.task;

import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.TaskCycleUnitEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
public class TaskCycleConfig implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 是否是周期任务
     * true-是
     */
    private Boolean cycle;

    /**
     * 自然周期，周期循环单位
     * 1-每日 2-每周(周一到周日) 3-每月 4-每年
     *
     * @see TaskCycleUnitEnum
     */
    private Integer taskCycleUnit;

    /**
     * 固定周期，每多少天一个周期
     */
    private Integer taskCycleDays;

    /**
     * 可完成次数限制，不填则不限次数（仅普通任务）
     */
    private Integer joinLimit;
}