package cn.com.duiba.cloud.duiba.activity.service.api.dto.task;

import cn.com.duiba.cloud.duiba.activity.service.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.RewardTypeEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * 任务奖励配置
 *
 * @TableName tb_task_reward_config
 */
@Setter
@Getter
public class TaskRewardConfigDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    /**
     * 任务Id
     */
    private Long taskId;

    /**
     * 奖励类型，1-积分，2-成长值，3-活动参与次数
     *
     * @see RewardTypeEnum
     */
    private Integer rewardType;

    /**
     * 奖励数额
     */
    private Long rewardValue;

    /**
     * 奖励内容
     */
    private RewardContent rewardContent;
}