package cn.com.duiba.cloud.duiba.activity.service.api.dto.task;


import cn.com.duiba.cloud.duiba.activity.service.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.RewardStatusEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * 奖励发放记录
 *
 * @TableName tb_task_reward_record
 */
@Setter
@Getter
public class TaskRewardRecordDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 奖励配置id
     */
    private Long rewardConfigId;

    /**
     * 用户参与记录id
     */
    private Long userRecordId;

    /**
     * 奖励记录状态，0-待领取，1-待发奖，2-发奖成功,3-发奖失败
     *
     * @see RewardStatusEnum
     */
    private Integer rewardStatus;

    /**
     * 发奖失败原因
     */
    private String rewardFailReason;

    /**
     * 奖励配置快照
     */
    private RewardConfigSnap rewardConfigSnap;
}