package cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx;

/**
 * @author: 郑建豪
 * @date: 2022/7/15 14:50
 * @description: 星速台奖品的类型，跟商品类型基本保持一致
 *  @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
 */
public enum ProjectxPrizeTypeEnum {
    OBJECT(1, "object", "实物"),
    COUPON(2, "coupon", "卡券"),
    RECHARGE(3, "virtual", "充值"),
    RIGHTS(4, "rights", "权益"),
    CREDITS(10, "increase-credits", "加积分"),

    ;


    private final Integer prizeType;
    private final String prizeCode;
    private final String desc;

    ProjectxPrizeTypeEnum(Integer prizeType, String prizeCode, String desc) {
        this.prizeType = prizeType;
        this.prizeCode = prizeCode;
        this.desc = desc;
    }

    public Integer getPrizeType() {
        return prizeType;
    }

    public String getPrizeCode() {
        return prizeCode;
    }

    public String getDesc() {
        return desc;
    }
}
