package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.answer;

import cn.com.duiba.cloud.duiba.activity.service.api.enums.CommonStatusEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.EnumValid;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 题目配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/14
 */
@Data
public class QuestionConfigVO implements Serializable {

    private static final long serialVersionUID = -8964511448986740862L;

    /**
     * 题目文案，最多60个字
     */
    @NotBlank(message = "题目文案不能为空")
    @Size(min = 1, max = 60, message = "题目文案长度限制为1～60个字符")
    private String title;

    /**
     * 题目是否有图片
     * 0-不展示 1-展示
     */
    @NotNull(message = "图片展示类型不能为空")
    @EnumValid(target = CommonStatusEnum.class, message = "图片展示类型不合法", field = "status")
    private Integer showPhoto;

    /**
     * 正确选项在optionList中的位置
     * 此处传字符串类型，方便以后扩展为多选
     */
    @NotBlank(message = "正确答案不能为空")
    private String rightOption;

    /**
     * 选项列表，至少2个，最多5个
     */
    @NotEmpty(message = "选项列表不能为空")
    @Size(min = 2, max = 5, message = "每道题目请配置2～5个选项")
    @Valid
    private List<OptionConfigVO> optionList;

}
