package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/3/24 16:36
 * @author:zhaozhanghai
 * @Description: [MallActivityDTO.attributes,TbMallActivity.attributes] json解析
 */
@Data
public class BaseActivityVo implements Serializable {
    /**
     * 自增ID
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动类型标识
     */
    private String activityType;

    /**
     * 活动模板编码
     */
    private String templateCode;

    /**
     * 0创建，1上架中，2下架，3终止
     */
    private Integer state;

    /**
     * 内容md5
     */
    private String commitId;

    /**
     * 操作人员
     */
    private String operator;


    /**
     * 活动规则描述
     */
    private String activityRule;

    /**
     * 活动开始时间 [1,2][开始时间时间戳,结束时间时间戳]
     */
    @Size(min = 2,max  =2,message = "活动时间格式错误")
    private String[] activityTime;

    /**
     * 是否支持积分参与 0-不支持 1-支持
     */
    @NotNull(message = "是否支持积分参与不能为空")
    @Range(min = 0,max = 1,message = "是否支持积分参与类型错误")
    private Integer isSupportCredits;

    /**
     * 是否开启浮标 0-不开启 1-开启
     */
    @NotNull(message = "是否开启浮标不能为空")
    @Range(min = 0,max = 1,message = "是否开启浮标类型错误")
    private Integer isOpenBuoy;

    /**
     * 浮标位置 1-左侧 2-右侧
     */
    @Range(min = 1,max = 2,message = "浮标位置类型错误")
    private Integer buoyPosition;

    /**
     * 浮标距离顶部位置px
     */
    private Integer buoyTopPx;

    /**
     * 浮标图片
     */
    private String buoyImage;

    /**
     * 浮标跳转配置
     */
    private BaseBuoyVo buoy;

    /**
     * 入口缩略图
     */
    private String banner;

    /**
     * 界面配置
     */
    private String interfaceConfiguration;
    /**
     * 分享开启 0-不开启 1-开启
     */
    @NotNull(message = "是否分享开启不能为空")
    @Range(min = 0,max = 1,message = "是否分享开启类型错误")
    private Integer isShareOpen;

    /**
     * 分享图片
     */
    private String shareImage;

    /**
     * 分享标题
     */
    private String shareTitle;

    /**
     * 分享副标题
     */
    private String shareSubtitle;

    /**
     * 地区限制 1-不限制 2-指定地区可参与 3-指定地区不可参与
     */
    @NotNull(message = "地区限制不能为空")
    @Range(min = 1,max = 3,message ="地区限制类型错误" )
    private Integer districtLimit;

    /**
     * 用户身份限制 1-不限制 2-指定用户可参与 3-指定用户不可参与
     */
    @NotNull(message = "用户身份限制不能为空")
    @Range(min = 1,max = 3,message ="用户身份限制类型错误" )
    private Integer identityLimit;

    /**
     * 用户身份限制 身份信息 [等级1，等级2，等级3]
     */
    private List<String> identityLimitLevel;

    /**
     * 参与积分
     */
    private Integer joinCredits;

    /**
     * 参与次数限制
     */
    private Integer joinLimit;

    /**
     * 参与次数限制单位 1-次/每天 2-次/永久
     */
    @Range(min = 1,max = 2,message ="参与次数限制单位类型错误" )
    private Integer joinLimitUnit;

    /**
     * 参与免费次数
     */
    private Integer joinFreeLimit;

    /**
     * 参与免费次数单位 1-次/每天 2-次/永久
     */
    private Integer joinFreeLimitUnit;



    /**
     * 用户分层参与 0-不开启 1-开启
     */
    @NotNull(message = "用户分层参与不能为空")
    @Range(min = 0,max = 1,message ="用户分层类型错误" )
    private Integer isIdentityLayeredJoin;



    /**
     * 省 区
     */
    private List<BaseDistrictVo> district;

    /**
     * 用户分层参与
     */
    private List<BaseUserLayeredJoinVo> userLayeredJoinConfig;

    /**
     * 发奖规则
     */
    @Valid
    private List<BaseRuleVo> rules;


    /**
     * 扩展字段
     */
    private String ext;

    /**
     * 是否勾选app 0-未勾选;1-勾选
     */
    @NotNull(message = "勾选app不能为空")
    private Integer putApp;

    /**
     * 是否勾选微信公众号 0-未勾选;1-勾选
     */
    @NotNull(message = "勾选微信公众号不能为空")
    private Integer putMp;

    /**
     * 是否勾选微信小程序 0-未勾选;1-勾选
     */
    @NotNull(message = "勾选微信小程序不能为空")
    private Integer putXcx;

    /****************************** 运营位配置 ******************************/

    /**
     * 运营位配置开启状态 0-不开启 1-开启
     */
    // 目前只是签到活动有这个配置，这个注解暂时去掉
//    @NotNull(message = "运营位配置开启状态不能为空")
//    @Range(min = 0, max = 1, message = "运营位配置开启状态错误")
    private Integer isOperatingPositionConfigOpen;

    /**
     * 运营位区域列表
     */
    private List<BaseOperatingPositionAreaVo> operatingPositionAreaList;
}
