package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.vote;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 投票适配转化成排行榜
 * 包含排行榜必填项字段
 * @author sunyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class Vote2RankConfigVO extends VoteRankRuleConfigVO implements Serializable {
    private static final long serialVersionUID = -3392516042289518199L;
    /**
     * 游戏难度
     */
    @NotNull(message = "游戏难度不能为空")
    private Integer gameDifficulty;

    /**
     * 单局游戏时常
     */
    @NotNull(message = "单局游戏时长不能为空")
    private Integer singleTime;

    /**
     * 是否开启概率出奖
     */
    private Integer probabilityPrize;

    /**
     * 是否开启排行榜出奖
     */
    private Integer rankPrize;
    /**
     * 开奖时间 时间戳
     */
    @NotNull
    private String lotteryTime;

    /**
     * 循环类型 1-自然日 2-自然周 3-自然月 4-自定义循环天
     */
    private Integer lotteryCycleType;
}
