package cn.com.duiba.cloud.duiba.activity.service.api.param.projectx;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangruofan
 * @date 2019/06/27
 */
@Data
public class ProjectxAwardRequest implements Serializable {

    private static final long serialVersionUID = 2661668270985339247L;

    /**
     * 发奖记录id，project x调用时无需指定
     */
    private Long prizeRecordId;

    /**
     * project x id
     * 必传
     */
    private String projectId;

    /**
     * 兑吧用户id
     */
    private Long consumerId;

    /**
     * appId
     */
    private Long appId;

    /**
     * 商品id
     * 必传
     */
    private Long itemId;

    /**
     * 兑吧商品类型
     * 必传
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx.ProjectxPrizeTypeEnum
     */
    private String itemType;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeIcon;

    /**
     * 档位
     * 当subType=virtual,increase-credits时不能为空
     * 非必传
     */
    private String degree;

    /**
     * project x order no
     * 必传
     */
    private String projectOrderNo;

    /**
     * 开发者扣积分订单号
     * 如果有扣积分则传
     * 非必传
     */
    private String developerBizId;

    /**
     * 附加信息,json格式
     */
    private String extJson;

    /**
     * 扣积分票据号：扣积分参与中奖时需要传
     */
    private String ticketNum;

    private String userAgent;

    private String ip;
    /**
     * 如果cookie里有则传
     * 非必传
     */
    private String transfer;

    private String description;

    /**
     * 来源渠道：1，app；2，微信H5；3，微信小程序
     *
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.SourceTerminalTypeEnum
     * 注：因为订单需要，所以前端传入来源，活动业务里带给订单
     */
    private Integer sourceTerminal;
}
