package cn.com.duiba.cloud.duiba.activity.service.api.param.projectx;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 消费者奖列表请求
 *
 * @author zouwx
 * @date 2022/04/02
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ProjectxUserPrizeListRequest extends PageRequest implements Serializable {

    private static final long serialVersionUID = 4460506700120128992L;

    /**
     * 消费者id
     */
    private Long consumerId;

    /**
     * 活动ids
     */
    private List<String> activityIds;

    /**
     * 领取状态：1-待领取 2-已领取 3-失败 4-已过期
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.ReceiveStatusEnum
     */
    private Integer receiveStatus;

    /**
     * 发奖状态列表：0，初始化；1，发奖中；2，待领取；3，领取中；4，已领取；5，领取失败；6，逾期未领取
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx.DrawStatusEnum
     */
    private List<Integer> drawStatusList;

    /**
     * 奖品类型：object，实物；coupon，卡券；virtual，充值；increase-credits，加积分
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.projectx.ProjectxPrizeTypeEnum
     */
    private List<String> itemTypeList;

}
