package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityKeepDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityKeepDailyDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTransDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTransDetailDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTransSumDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTrendAllDataDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTrendDailyDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData.ActivityTrendDataDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityData.ActivityKeepPageParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityData.ActivityTransDetailParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityData.ActivityTransParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityData.ActivityTrendParam;

import java.util.Date;
import java.util.List;

/**
 * @date:2022/4/14 11:50
 * @author:zhaozhanghai
 * @Description: 活动数据
 */
@AdvancedFeignClient
public interface RemoteActivityDataService {

    /**
     * 获取活动趋势总数据
     *
     * @param activityIds
     * @return
     */
    List<ActivityTrendAllDataDTO> trendAll(List<Long> activityIds);


    /**
     * 根据活动查询最新的和最老的数据时间
     * @param activityId
     * @return
     */
    List<Date> getTrendStartAndEndDate(Long activityId);

    /**
     * 获取单个活动时间范围内的趋势数据
     *
     * @param activityTrendParam
     * @return
     */
    List<ActivityTrendDataDTO> trend(ActivityTrendParam activityTrendParam);

    /**
     * 获取今日的活动数据
     *
     * @param activityId
     * @return
     */
    List <ActivityTrendDailyDTO> trendDaily(Long activityId);


    /**
     * 根据活动查询最新的和最老的数据时间
     * @param activityId
     * @return
     */
    List<Date> getKeepStartAndEndDate(Long activityId);

    /**
     * 单个活动留存分页
     *
     * @param activityKeepPageParam
     * @return
     */
    List<ActivityKeepDTO> keepPage(ActivityKeepPageParam activityKeepPageParam);


    /**
     * 当日的留存
     *
     * @param activityKeepPageParam
     * @return
     */
    List<ActivityKeepDailyDTO> keepDaily(ActivityKeepPageParam activityKeepPageParam);


    /**
     * 根据活动查询最新的和最老的数据时间
     * @param activityId
     * @return
     */
    List<Date> getTransStartAndEndDate(Long activityId);

    /**
     * 获取单个活动时间范围内的转化数据
     *
     * @param activityTransParam
     * @return
     */
    List<ActivityTransDTO> trans(ActivityTransParam activityTransParam);

    /**
     * 获取单个活动时间范围内的转化汇总数据(分页)
     *
     * @param activityTransDetailParam
     * @return
     */
    List<ActivityTransDetailDTO> transDetail(ActivityTransDetailParam activityTransDetailParam);


    /**
     * 获取汇总信息
     * @param activityTransParam
     * @return
     */
    List<ActivityTransSumDTO> sumList(ActivityTransParam activityTransParam);
}
