package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.invite;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayAcceptInviteDTO;

import java.util.List;
import java.util.Optional;

@AdvancedFeignClient
public interface InviteUserRequestApi {
    /**
     * 获取用户全部邀请记录
     * @return List<AcceptInviteRecord>
     */
    List<PlaywayAcceptInviteDTO> getAllInviteList(Long activityId, String playwayId, Long cid);

    /**
     * 获取用户今天邀请成功的记录
     * @return
     */
    List<PlaywayAcceptInviteDTO> getTodayInviteList(Long activityId, String playwayId, Long cid);

    /**
     * 查询我的邀请码，如果数据库不存在，返回null
     * @return
     */
    String findInviteCode(Long activityId, String playwayId, Long cid);

    /**
     * 通过邀请码返回用户id
     * @param code 邀请码
     * @return userId
     */
    Optional<Long> getInviterByCode(Long activityId, String code);

    /**
     *
     * @param activityId 活动id
     * @param playwayId 玩法ID
     * @param cid 用户id
     * @param codeLength 希望的code长度，建议不小于6位，位数过短会导致生成的code重复，创建失败
     * @return
     * @throws BizException
     */
    String getOrGenCode(Long activityId, String playwayId, Long cid, int codeLength) throws BizException;

    /**
     *
     * @param codes 自己创建Code，需要自行保证Code的唯一性
     * @return
     */
    String getOrGenCodeSelf(Long activityId, String playwayId, Long cid, String... codes) throws BizException;

    /**
     * 接受邀请
     * @param code
     * @return
     */
    void acceptInvite(Long activityId, Long cid, String code) throws BizException;

    /**
     * 接收邀请并设置extra
     * extra最长255，支持emoji
     * @param code invite code
     * @param extra extra info
     */
    void acceptInviteWithExtra(Long activityId, Long cid, String code, String extra) throws BizException;
}
