package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.scoring;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayActionRecordDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayLeaderboardArchiveDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayRankingDTO;

import java.util.List;

/**
 * 记分玩法API
 * 1.用户请求记分玩法的接口时，自定义代码区域可使用此API
 *
 */
@AdvancedFeignClient
public interface ScoringUserRequestApi {

    /**
     * 开始参与，等同于 JoinUserRequestApiImpl#doJoin
     * @param activityId 活动id
     * @param playwayId 玩法id
     * @param userId 用户id
     * @param extra 扩展信息
     * @return 参与记录id，即后续其他方法的入参startId
     */
    Long start(Long activityId, String playwayId, Long userId, String extra);

    /**
     * 提交分数，并计入排行榜
     * @param startId 参与记录
     * @param score 提交的分数
     */
    void submitScoreWithRank(Long activityId, String playwayId, Long cid, long startId, int score) throws BizException;

    /**
     * 提交分数，并计入排行榜
     * @param startId 参与记录
     * @param score 提交的分数
     */
    void submitScorePlayIdWithRank(Long activityId, String playwayId, Long cid, long startId, int score, String rankPlaywayId) throws BizException;

    /**
     * 查询今日参与次数
     * @return 用户当前活动今日的参与次数
     */
    Long queryUserTodayCount(Long activityId, String playwayId, Long cid);

    /**
     * 通过id查询参与记录
     * @param startId 参与id
     * @return ActionRecordDto
     */
    PlaywayActionRecordDTO findById(long startId);

    /**
     * 查询一次游戏提交的次数
     * @param startId 参与id
     * @return 次数
     */
    int countTimes(long startId);

    /**
     * 获取前几名的排行榜信息
     * @param topN 前几名
     *             不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<PlaywayRankingDTO> getTopN(Long activityId, int topN);

    /**
     * 获取前几名的排行榜信息
     * @param rankPlaywayId 排行榜玩法ID
     * @param topN 前几名
     *             不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<PlaywayRankingDTO> getTopNPlayId(Long activityId, String rankPlaywayId, int topN);

    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     * @return
     * @throws BizException
     */
    String getCurrentRankingType(Long activityId) throws BizException;


    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     * @throws BizException
     */
    String getCurrentRankingTypeAndPlayId(Long activityId, String rankPlaywayId) throws BizException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @return
     * @throws BizException
     */
    String getPrefixRankingType(Long activityId) throws BizException;

    /**
     * 获取新排行榜上一期的rankingType
     * @param rankPlaywayId 排行榜玩法ID
     *
     * @return
     * @throws BizException
     */
    String getPrefixRankingTypeAndPlayId(Long activityId, String rankPlaywayId) throws BizException;

    /**
     * 根据期次type查询期次数据
     *
     * @param activityId 活动id
     * @param rankType   等级类型
     * @return {@link PlaywayLeaderboardArchiveDTO}
     */
    PlaywayLeaderboardArchiveDTO getLeaderboardArchiveByRankType(Long activityId,String rankType);

}
