package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.projectx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx.GeneralStockDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.UserPrizeDetailDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx.PrizeResultBaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx.ProjectxPrizeRecordDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx.ProjectxUserPrizeDetailDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.projectx.ProjectxUserPrizePageDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.AllocateStockRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.CouponRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.GetStockByGeneralIdParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.PrizeRecordRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.ProjectxAwardRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.ProjectxReceiveRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.projectx.ProjectxUserPrizeListRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/7/11
 * @description
 */
@AdvancedFeignClient
public interface RemoteProjectXService {

	/**
	 * 项目发奖
	 */
	Long award(ProjectxAwardRequest request) throws BizException;

	/**
	 * 分页查询用户奖项记录页面
	 *
	 * @param projectxUserPrizeListRequest 用户奖列表请求
	 * @return {@link PageResponse}<{@link ProjectxUserPrizePageDTO}>
	 * @throws BizException 业务异常
	 */
	PageResponse<ProjectxUserPrizePageDTO> findUserPrizeRecordPage(ProjectxUserPrizeListRequest projectxUserPrizeListRequest) throws BizException;

	/**
	 * 查询用户领取详情
	 *
	 * @param userPrizeId 用户奖id
	 * @return {@link UserPrizeDetailDTO}
	 * @throws BizException 业务异常
	 */
	ProjectxUserPrizeDetailDTO findUserPrizeDetail(Long userPrizeId) throws BizException;

	/**
	 * 手动领奖：实物、需要填写账号的虚拟商品 需要手动领奖
	 */
	Long takePrize(ProjectxReceiveRequest request) throws BizException;

	/**
	 * 获取发奖记录
	 *
	 * @param projectOrderNo projectOrderNo
	 * @return dto
	 */
	ProjectxPrizeRecordDTO findPrizeRecordByProjectOrderNo(String projectOrderNo);

	/**
	 * 批量获取发奖记录
	 * @param prizeRecordRequest
	 * @return
	 */
	List<ProjectxPrizeRecordDTO> selectPrizeRecordByProjectOrderNos(PrizeRecordRequest prizeRecordRequest);

	/**
	 * 获取发奖记录
	 *
	 * @param id id
	 * @return dto
	 */
	ProjectxPrizeRecordDTO findPrizeRecordById(Long id);

	/**
	 * 获取优惠券信息
	 * @param couponRequest
	 * @return
	 */
	PrizeResultBaseDto.Lottery getCouponInfo(CouponRequest couponRequest) throws BizException;

	/**
	 * 分配渠道库存
	 * @param allocateStockRequest
	 * @return
	 * @throws BizException
	 */
	Boolean allocateStock(AllocateStockRequest allocateStockRequest) throws BizException;

	/**
	 * 查询某个generalId是否有库存
	 * @param getStockByGeneralIdParam
	 * @return
	 * @throws BizException
	 */
	GeneralStockDTO hasStock(GetStockByGeneralIdParam getStockByGeneralIdParam);
}
