package cn.com.duiba.cloud.duiba.activity.service.api.enums.exception;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ErrorCode.java
 * @Description 异常返回枚举
 * @createTime 2021年07月14日 14:55:00
 */
public enum ErrorCode {
    /**
     * 999开头为系统级异常
     */
    ERROR("999999", "未知异常"),
    REQUEST_FREQUENTLY("999998", "请求过于频繁，请稍后再试"),
    DATA_ERROR("999997", "数据异常，请联系管理员"),
    APP_INFO_INVALID("888888", "应用信息已失效，请重新选择"),
    NEED_LONGIN("000000","请先登录"),
    UNKNOWN_OPERATOR("0000001", "未知操作人"),
    FAULTY_PAGINATION_PARAM("0000002", "不正确的分页参数"),
    PARAM_IS_NOT_NULL("0000003", "必填参数不能为空"),
    TENANT_COOKIE_INVALID("0000004", "租户cookie已失效"),
    UPDATE_TEL_FAIL("0000005", "手机号已注册，请重新输入"),
    FILE_NOT_EXISTS("0000006", "文件不存在"),
    UPLOAD_EXCEL_FILE("0000007", "请上传正确的EXCEL文件，以.xls或.xlsx结尾"),
    ERROR_PARAM("0000008", "参数错误"),
    PARAM_NOT_SPECIFICATION("0000009", "[]字段输入不合规"),
    CAPTCHA_ERROR("0000010", "图片验证码错误"),
    EMAIL_ERROR("0000011", "邮箱格式错误"),
    CAPTCHA_VALIDATE_FAIL("0000012", "验证码校验不通过"),
    ENUM_UTIL_GET_FIELD_IS_NULL("0000013", "枚举类错误,请添加Code注解或命名字段为code"),
    QUERY_DAY_OUT_OF_RANGE("0000014", "只能查询最近[]天的数据"),
    MOBILE_ERROR("0000015", "手机号格式错误"),
    USER_ID_NOT_NULL("0000016", "用户id不能为空"),
    MULTI_CHANNEL_CONFIG_EEROR("0000017", "多渠道投放有误，需配置对应免登地址"),
    NO_CHANNEL_CONFIG_EEROR("0000018", "请至少配置一个多渠道投放"),
    CHANNEL_UPDATE_EEROR("0000019", "编辑状态不可更改渠道配置"),




    ;

    private String code;

    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
