package cn.com.duiba.cloud.duiba.activity.service.api.enums.task;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * 任务类型
 */
public enum TaskTypeEnum implements IEnum<Integer> {
    JUMP(1, "跳转任务"),
    BACKEND(2, "接口任务"),
    SIGN(3, "签到任务"),
    SHARE(4, "分享任务"),
    ;

    private final Integer taskType;
    private final String desc;

    TaskTypeEnum(Integer taskType, String desc) {
        this.taskType = taskType;
        this.desc = desc;
    }


    public Integer getTaskType() {
        return taskType;
    }

    public String getDesc() {
        return desc;
    }

    @Override
    public Integer getDbCode() {
        return getTaskType();
    }
}
