package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.collect;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 助力规则配置
 * @Author dangcang
 * @Date 2022/6/27 3:20 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class ShareConfigToVO extends BaseShareConfigVO implements Serializable {

    private static final long serialVersionUID = 2926116040510531404L;
    /**
     * 助力资格规则
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.collect.HelpUserTypeEnum
     */
    @NotNull(message = "助力资格规则限制不能为空")
    @Range(min = 1, max = 2, message = "助力资格规则限制类型错误")
    private Integer helpUserType;

    /**
     * 是否开启助力奖励
     */
    @NotNull(message = "是否开启助力奖励不能为空")
    private Boolean canHelp;
}