package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.sign;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 契约签到特有参数
 * @Author dangcang
 * @Date 2022/6/13 2:58 下午
 **/
@Data
public class ContractSignVO implements Serializable {

    private static final long serialVersionUID = 1301258438065953997L;
    /**
     * 投注选项
     */
    @NotEmpty(message = "投注选项不能为空")
    @Size(min = 3, max = 3, message = "请配置3个选项")
    private List<Integer> optionList;

    /**
     * 是否开启奖励补贴
     */
    @NotNull(message = "是否开启奖励补贴不能为空")
    private Boolean openAward;

    /**
     * 积分补贴数量 openAward=TRUE时必填
     */
    private Long awardNumber;

    /**
     * 打卡周期
     */
    @NotNull(message = "打卡周期不能为空")
    @Range(min = 7, max = 31, message = "打卡周期为7-31之间的整数")
    private Long period;

    /**
     * 是否开启任务
     */
    @NotNull(message = "是否开启任务不能为空")
    private Boolean openTask;

    /**
     * 任务列表 openTask=TRUE时必填 顺序就是任务的顺序
     */
    private List<List<Long>> taskIdList;
}