package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.vote;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 投票排行
 * @author sunyan
 */
@Data
public class VoteRankRuleConfigVO implements Serializable {
    private static final long serialVersionUID = 8004674489021481296L;
    /**
     * 报名方式
     * 1-不支持报名；2-线上报名；3-联系主办方报名
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.vote.VoteSignupTypeEnum
     */
    @NotNull(message="报名方式不能为空")
    @Range(min = 1,max = 3,message ="报名方式类型错误" )
    private Integer signupType;

    /**
     * 主办方联系方式
     */
    private String contactInfo;

    /**
     * 投票项展示
     * 1-审核时间；2-投票数量
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.vote.VoteItemShowTypeEnum
     */
    @NotNull(message="是否开启排行榜出奖不能为空")
    @Range(min = 1,max = 2,message ="投票项展示类型错误" )
    private Integer voteItemShowType;

    /**
     * 投票项顺序
     * 1-正序；2-倒序
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.vote.VoteItemShowSortEnum
     */
    @NotNull(message="是否开启排行榜出奖不能为空")
    @Range(min = 1,max = 2,message ="投票项顺序类型错误" )
    private Integer voteItemShowSort;

    /**
     * 单项投票限制
     */
    private Integer voteLimit;

    /**
     * 单项投票限制单位
     * 1-次/每天 2-次/永久
     */
    @Range(min = 1,max = 2,message ="单项投票限制单位类型错误" )
    private Integer voteLimitUnit;

    /**
     * 投票成功后
     * 1-跳转营销页；2-概率出奖
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.vote.AfterVoteEnum
     */
    @NotNull(message="投票成功后不能为空")
    @Range(min = 1,max = 2,message ="投票成功后类型错误" )
    private Integer afterVote;

    /**
     * 营销页面地址
     */
    private MarketingUrlVO marketingUrl;

    /**
     * 概率出奖触发
     * 1-首次投票；2-每次投票
     */
    private Integer probabilityTrigger;

    /**
     * 是否开启排行榜出奖
     * 0-否；1-是
     */
    @NotNull(message="是否开启排行榜出奖不能为空")
    private Integer openRank;

    /**
     * 排行榜类型
     * 1-线下发奖；2-线上发奖
     */
    private Integer rankType;

    /**
     * 线下发奖奖品列表
     */
    private List<OfflineRankPrizeVo> offlineRankPrizes;
}
